<?php

namespace Model;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Voting extends Eloquent {

	protected $table = 'votings';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('first_preference', 'second_preference', 'third_preference', 'election_polling_area_id');

	public function voter()
	{
		return $this->belongsTo('Model\VoterDetail', 'voucher_id');
	}

	public function polling_area()
	{
		return $this->belongsTo('Model\ElectionPollingArea', 'election_polling_area_id');
	}

}