<?php

namespace Model;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Result extends Model 
{

    protected $table = 'results';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('election_polling_area_id', 'first_preference_voting', 'second_preference_voting', 'third_preference_voting');

    public function polling_area()
    {
        return $this->belongsTo('Model\ElectionPollingArea', 'polling_area_id');
    }

}