<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserTable extends Migration {

	public function up()
	{
		Schema::create('User', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('email', 255);
			$table->string('motdepasse', 255);
			$table->string('nom', 50);
			$table->string('prenom', 50);
			$table->string('adresse', 255)->nullable();
			$table->mediumInteger('cp')->unsigned()->nullable();
			$table->string('ville', 255)->nullable();
			$table->string('tel', 11)->nullable();
			$table->boolean('rgpd')->default(false);
			$table->bigInteger('role-id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('User');
	}
}