<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('User', function(Blueprint $table) {
			$table->foreign('role-id')->references('id')->on('Role')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Demande', function(Blueprint $table) {
			$table->foreign('commande-id')->references('id')->on('Commande')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Demande', function(Blueprint $table) {
			$table->foreign('statutDemande-id')->references('id')->on('StatutDemande')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Commande', function(Blueprint $table) {
			$table->foreign('user-id')->references('id')->on('User')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('User', function(Blueprint $table) {
			$table->dropForeign('User_role-id_foreign');
		});
		Schema::table('Demande', function(Blueprint $table) {
			$table->dropForeign('Demande_commande-id_foreign');
		});
		Schema::table('Demande', function(Blueprint $table) {
			$table->dropForeign('Demande_statutDemande-id_foreign');
		});
		Schema::table('Commande', function(Blueprint $table) {
			$table->dropForeign('Commande_user-id_foreign');
		});
	}
}