<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('user_tokens', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('place_sliders', function(Blueprint $table) {
			$table->foreign('place_id')->references('id')->on('places')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('place_tags', function(Blueprint $table) {
			$table->foreign('place_id')->references('id')->on('places')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('places_categories', function(Blueprint $table) {
			$table->foreign('place_id')->references('id')->on('places')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('places_categories', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('food_categories')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('foods', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('food_categories')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('foods', function(Blueprint $table) {
			$table->foreign('place_id')->references('id')->on('places')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('favourites', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('favourites', function(Blueprint $table) {
			$table->foreign('place_id')->references('id')->on('places')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('favourites', function(Blueprint $table) {
			$table->foreign('food_id')->references('id')->on('foods')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('rates', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('rates', function(Blueprint $table) {
			$table->foreign('place_id')->references('id')->on('places')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('rates', function(Blueprint $table) {
			$table->foreign('food_id')->references('id')->on('foods')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('food_sliders', function(Blueprint $table) {
			$table->foreign('food_id')->references('id')->on('foods')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('offers', function(Blueprint $table) {
			$table->foreign('place_id')->references('id')->on('places')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('user_tokens', function(Blueprint $table) {
			$table->dropForeign('user_tokens_user_id_foreign');
		});
		Schema::table('place_sliders', function(Blueprint $table) {
			$table->dropForeign('place_sliders_place_id_foreign');
		});
		Schema::table('place_tags', function(Blueprint $table) {
			$table->dropForeign('place_tags_place_id_foreign');
		});
		Schema::table('places_categories', function(Blueprint $table) {
			$table->dropForeign('places_categories_place_id_foreign');
		});
		Schema::table('places_categories', function(Blueprint $table) {
			$table->dropForeign('places_categories_category_id_foreign');
		});
		Schema::table('foods', function(Blueprint $table) {
			$table->dropForeign('foods_category_id_foreign');
		});
		Schema::table('foods', function(Blueprint $table) {
			$table->dropForeign('foods_place_id_foreign');
		});
		Schema::table('favourites', function(Blueprint $table) {
			$table->dropForeign('favourites_user_id_foreign');
		});
		Schema::table('favourites', function(Blueprint $table) {
			$table->dropForeign('favourites_place_id_foreign');
		});
		Schema::table('favourites', function(Blueprint $table) {
			$table->dropForeign('favourites_food_id_foreign');
		});
		Schema::table('rates', function(Blueprint $table) {
			$table->dropForeign('rates_user_id_foreign');
		});
		Schema::table('rates', function(Blueprint $table) {
			$table->dropForeign('rates_place_id_foreign');
		});
		Schema::table('rates', function(Blueprint $table) {
			$table->dropForeign('rates_food_id_foreign');
		});
		Schema::table('food_sliders', function(Blueprint $table) {
			$table->dropForeign('food_sliders_food_id_foreign');
		});
		Schema::table('offers', function(Blueprint $table) {
			$table->dropForeign('offers_place_id_foreign');
		});
	}
}