<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;
    protected $fillable = array('name', 'email', 'mobile', 'password', 'image', 'lat', 'lng', 'status', 'type', 'verified', 'code');

    public function tokens()
    {
        return $this->hasMany('Models\Token', 'user_id');
    }

    public function favourite_places()
    {
        return $this->belongsToMany('Models\Place', 'favourites', 'user_id', 'place_id');
    }

    public function favourite_foods()
    {
        return $this->belongsToMany('Models\Food', 'favourites', 'user_id', 'food_id');
    }

    public function rate_places()
    {
        return $this->belongsToMany('Models\Place', 'rates', 'user_id', 'place_id');
    }

    public function rate_foods()
    {
        return $this->belongsToMany('Models\Food', 'rates', 'user_id', 'food_id');
    }

}