<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePlacesTable extends Migration {

	public function up()
	{
		Schema::create('places', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 191)->nullable();
			$table->string('logo', 191)->nullable();
			$table->enum('type', array('restaurant', 'cafe'))->nullable();
			$table->text('description')->nullable();
			$table->string('lat', 191)->nullable();
			$table->string('lng', 191)->nullable();
			$table->enum('status', array('active', 'not_active'))->nullable();
		});
	}

	public function down()
	{
		Schema::drop('places');
	}
}