<?php

namespace Models;

class Place extends Eloquent {

	protected $table = 'places';
	public $timestamps = true;
	protected $fillable = array('name', 'logo', 'type', 'description', 'lat', 'lng', 'status');

	public function sliders()
	{
		return $this->hasMany('Models\PlaceSlider', 'place_id');
	}

	public function tags()
	{
		return $this->hasMany('Models\PlaceTags', 'place_id');
	}

	public function categories()
	{
		return $this->belongsToMany('Models\FoodCategory', 'places_categories', 'place_id', 'category_id');
	}

	public function foods()
	{
		return $this->hasMany('Models\Food', 'place_id');
	}

	public function favourite_users()
	{
		return $this->belongsToMany('\User', 'favourites', 'place_id', 'user_id');
	}

	public function rate_users()
	{
		return $this->belongsToMany('\User', 'rates', 'place_id', 'user_id');
	}

	public function offers()
	{
		return $this->hasMany('Models\Offer', 'place_id');
	}

}