<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('full_name', 80)->nullable();
			$table->string('email', 80)->nullable();
			$table->string('password', 255)->nullable();
			$table->timestamp('email_verified_at')->nullable();
			$table->integer('organization_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}