<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrderItemsTable extends Migration {

	public function up()
	{
		Schema::create('order_items', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('order_id');
			$table->smallInteger('quantity');
			$table->decimal('item_total_cost');
			$table->integer('product_id')->unsigned();
			$table->integer('discount_id')->unsigned()->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('order_items');
	}
}