<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAddressesTable extends Migration {

	public function up()
	{
		Schema::create('addresses', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id')->unsigned();
			$table->enum('type', array('home', 'business'));
			$table->boolean('is_primary');
			$table->string('google_place_id')->nullable();
			$table->string('street_address', 128);
			$table->string('street_address_2', 128)->nullable();
			$table->string('city', 128);
			$table->string('state', 128);
			$table->string('postal_code', 10);
			$table->string('country');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('addresses');
	}
}