<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCustomersTable extends Migration {

	public function up()
	{
		Schema::create('customers', function(Blueprint $table) {
			$table->increments('id');
			$table->enum('type', array('personal', 'business'))->nullable();
			$table->integer('user_id')->unsigned();
			$table->string('billing_company_name')->nullable();
			$table->string('billing_first_name');
			$table->string('billing_last_name');
			$table->integer('billing_address_id')->unsigned();
			$table->string('currency');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('customers');
	}
}