<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDiscountsTable extends Migration {

	public function up()
	{
		Schema::create('discounts', function(Blueprint $table) {
			$table->increments('id');
			$table->string('description')->nullable();
			$table->string('code', 10);
			$table->decimal('amount', 8,2);
			$table->string('amount_type', 128);
			$table->timestamp('start_date');
			$table->timestamp('end_date')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('discounts');
	}
}