<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('order_number');
			$table->string('hashed_id', 255);
			$table->integer('customer_id')->unsigned()->nullable();
			$table->enum('status', array('pending', 'processing', 'complete'));
			$table->integer('transaction_id')->unsigned();
			$table->integer('discount_id')->unsigned()->default('0');
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}