<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTransactionsTable extends Migration {

	public function up()
	{
		Schema::create('transactions', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('customer_id')->unsigned()->nullable();
			$table->string('receipt_number', 128);
			$table->integer('payment_method_id')->unsigned();
			$table->enum('payment_type', array(''));
			$table->integer('discount_id')->unsigned();
			$table->text('description');
			$table->integer('total')->unsigned();
			$table->string('transaction_reference', 128);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('transactions');
	}
}