<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSellingSpecialNumbersTable extends Migration {

	public function up()
	{
		Schema::create('selling_special_numbers', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->string('name_ar')->nullable();
			$table->string('name_en')->nullable();
			$table->text('description_ar')->nullable();
			$table->text('description_en');
			$table->string('record_number')->nullable();
			$table->string('logo')->nullable();
			$table->boolean('active')->default(true);
			$table->boolean('availablity')->default(true);
			$table->bigInteger('country_id')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('selling_special_numbers');
	}
}