<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateServicesTable extends Migration {

	public function up()
	{
		Schema::create('services', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->string('servable_type');
			$table->bigInteger('servable_id');
			$table->string('name_ar')->nullable();
			$table->string('name_en')->nullable();
			$table->text('description_ar')->nullable();
			$table->string('description_en')->nullable();
			$table->double('price', 8,2)->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('services');
	}
}