<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRentalCarsTable extends Migration {

	public function up()
	{
		Schema::create('rental_cars', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->bigInteger('brand_id')->unsigned();
			$table->string('type')->nullable();
			$table->string('model')->nullable();
			$table->string('color')->nullable();
			$table->double('daily_rental', 8,2)->nullable();
			$table->double('weekly_rental', 8,2)->nullable();
			$table->double('monthly_rental', 8,2)->nullable();
			$table->double('yearly_rent', 8,2)->nullable();
			$table->boolean('active')->default(true);
			$table->boolean('availablity')->default(true);
			$table->bigInteger('rental_office_id')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('rental_cars');
	}
}