<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('customer_id')->unsigned();
			$table->integer('order_status');
			$table->text('notes')->nullable();
			$table->decimal('total_cost')->default('0');
			$table->integer('resturant_id')->unsigned();
			$table->integer('payment_way_id')->unsigned();
			$table->time('pick_time')->nullable();
			$table->string('coupon_code')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}