<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Application extends Model 
{

    protected $table = 'applications';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function applicant()
    {
        return $this->belongsTo('Applicant');
    }

    public function program()
    {
        return $this->belongsTo('Program');
    }

    public function files()
    {
        return $this->hasMany('ApplicationFiles');
    }

    public function criteriaRatings()
    {
        return $this->hasMany('CriteriaRatings');
    }

}