<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateApplicationsTable extends Migration {

	public function up()
	{
		Schema::create('applications', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('applicant_id');
			$table->string('semester');
			$table->string('program_id');
			$table->string('program_code');
			$table->bigInteger('gpa')->nullable();
			$table->bigInteger('gre_v');
			$table->string('gre_q')->nullable();
			$table->string('decision')->nullable();
			$table->timestamp('decision_date')->nullable();
			$table->integer('employer_subsidy')->nullable();
			$table->integer('experience')->nullable();
			$table->string('specialty')->nullable();
			$table->string('specialty_other')->nullable();
			$table->longText('notes')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('applications');
	}
}