<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Criteria extends Model 
{

    protected $table = 'criteria';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function rubric()
    {
        return $this->belongsTo('Rubric');
    }

    public function criteriaValues()
    {
        return $this->hasMany('CriteriaValues');
    }

}