<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class CriteriaValues extends Model 
{

    protected $table = 'criteria_values';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function criteria()
    {
        return $this->belongsTo('Criteria');
    }

    public function criteriaRatings()
    {
        return $this->hasMany('CriteriaRatings');
    }

}