<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMarketersTable extends Migration {

	public function up()
	{
		Schema::create('marketers', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('facebook_id')->unique()->nullable();
			$table->string('google_id')->unique()->nullable();
			$table->string('username')->unique();
			$table->string('email')->unique();
			$table->string('phone')->unique();
			$table->string('password');
			$table->boolean('email_status')->default(0);
			$table->boolean('phone_status')->default(0);
			$table->integer('vcode_email');
			$table->integer('vcode_phone')->nullable();
			$table->boolean('status')->default(0);
			$table->integer('payment_method_id')->unsigned();
			$table->string('name')->nullable();
			$table->string('page_link')->nullable();
			$table->string('brand_name')->nullable();
			$table->integer('city_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('marketers');
	}
}