<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateContactsTable extends Migration {

	public function up()
	{
		Schema::create('contacts', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->enum('type', array('order', 'msg', 'product', 'otherproduct'));
			$table->integer('product_id')->nullable();
			$table->integer('order_id')->nullable();
			$table->boolean('status')->default(0);
			$table->integer('company_id')->unsigned();
			$table->morphs('user');
			$table->string('name')->nullable();
			$table->string('phone')->nullable();
			$table->text('msg')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('contacts');
	}
}