<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCompaniesTable extends Migration {

	public function up()
	{
		Schema::create('companies', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name')->unique();
			$table->string('base_url', 1000)->unique();
			$table->date('expiry_date');
			$table->integer('plan_id')->unsigned();
			$table->boolean('status')->default(1);
			$table->integer('country_id')->unsigned();
			$table->string('username');
			$table->string('password');
		});
	}

	public function down()
	{
		Schema::drop('companies');
	}
}