<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSupplierProductQuantityControlTable extends Migration {

	public function up()
	{
		Schema::create('supplier_product_quantity_control', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->enum('type', array('in', 'out'));
			$table->integer('quantity');
			$table->string('supplier_id');
			$table->string('product_id');
		});
	}

	public function down()
	{
		Schema::drop('supplier_product_quantity_control');
	}
}