<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateWalletsTable extends Migration {

	public function up()
	{
		Schema::create('wallets', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->morphs('user');
			$table->double('expected')->default('0');
			$table->double('available')->default('0');
			$table->double('withdrawal')->default('0');
		});
	}

	public function down()
	{
		Schema::drop('wallets');
	}
}