<?php

namespace App\Models;

class PaymentStatistics extends Eloquent {

	protected $table = 'payment_statistics';
	public $timestamps = true;

	public function payment()
	{
		return $this->belongsTo('App\Models\Payment', 'payment_id');
	}

	public function customer()
	{
		return $this->belongsTo('App\Models\Customer', 'customer_id');
	}

	public function order_id()
	{
		return $this->belongsTo('App\Models\Order', 'order_id');
	}

	public function subscription()
	{
		return $this->belongsTo('App\Models\Subscription', 'subscription_id');
	}

	public function payment_type()
	{
		return $this->belongsTo('App\Models\PaymentType', 'payment_type_id');
	}

	public function product()
	{
		return $this->belongsTo('App\Models\Product', 'product_id');
	}

}