<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Sell_rder extends Eloquent {

	protected $table = 'sell_order';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('distribution_center_id', 'description');

	public function bills()
	{
		return $this->hasMany('Sell_bill');
	}

	public function distribution_centers()
	{
		return $this->hasOne('DistributionCenter');
	}

}