<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Store extends Eloquent {

	protected $table = 'store';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'capacity', 'current_capacity', 'status', 'location_id', 'store_category_id');

	public function location()
	{
		return $this->hasOne('Location');
	}

}