<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('fname', 'lname', 'email', 'password', 'phone');
	protected $hidden = array('password');

	public function distributionCenter()
	{
		return $this->belongsTo('DistributionCenter');
	}

}