<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAccountsTable extends Migration {

	public function up()
	{
		Schema::create('accounts', function(Blueprint $table) {
			$table->increments('id');
			$table->string('amount');
			$table->text('note');
			$table->enum('type', array('deposit', 'withdrawal'));
			$table->integer('moderator_id')->unsigned();
			$table->integer('acccount_cat_id')->unsigned();
			$table->integer('employee_id')->unsigned();
			$table->integer('student_id')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('accounts');
	}
}