<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBorrowsTable extends Migration {

	public function up()
	{
		Schema::create('borrows', function(Blueprint $table) {
			$table->increments('id');
			$table->string('amount');
			$table->text('note');
			$table->integer('employee_id')->unsigned();
			$table->integer('moderator_id')->unsigned();
			$table->timestamps();
			$table->enum('status', array('pendding', 'paid'));
		});
	}

	public function down()
	{
		Schema::drop('borrows');
	}
}