<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('students', function(Blueprint $table) {
			$table->foreign('stage_id')->references('id')->on('stages')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('employees', function(Blueprint $table) {
			$table->foreign('department_id')->references('id')->on('departments')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('departments', function(Blueprint $table) {
			$table->foreign('parent')->references('id')->on('departments')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('moderator_departments', function(Blueprint $table) {
			$table->foreign('moderator_id')->references('id')->on('moderators')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('moderator_departments', function(Blueprint $table) {
			$table->foreign('department_id')->references('id')->on('departments')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('leaves', function(Blueprint $table) {
			$table->foreign('employee_id')->references('id')->on('employees')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('leaves', function(Blueprint $table) {
			$table->foreign('leave_type')->references('id')->on('leaves_types')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('leaves', function(Blueprint $table) {
			$table->foreign('department_id')->references('id')->on('departments')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('rewards', function(Blueprint $table) {
			$table->foreign('employee_id')->references('id')->on('employees')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('rewards', function(Blueprint $table) {
			$table->foreign('moderator_id')->references('id')->on('moderators')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('borrows', function(Blueprint $table) {
			$table->foreign('employee_id')->references('id')->on('employees')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('borrows', function(Blueprint $table) {
			$table->foreign('moderator_id')->references('id')->on('moderators')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('discounts', function(Blueprint $table) {
			$table->foreign('employee_id')->references('id')->on('employees')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('discounts', function(Blueprint $table) {
			$table->foreign('moderator_id')->references('id')->on('moderators')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('rates', function(Blueprint $table) {
			$table->foreign('moderator_id')->references('id')->on('moderators')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('rates', function(Blueprint $table) {
			$table->foreign('employee_id')->references('id')->on('employees')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('rates', function(Blueprint $table) {
			$table->foreign('student_id')->references('id')->on('students')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('holidays', function(Blueprint $table) {
			$table->foreign('department_id')->references('id')->on('departments')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('holidays', function(Blueprint $table) {
			$table->foreign('moderator_id')->references('id')->on('moderators')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('stages', function(Blueprint $table) {
			$table->foreign('parent')->references('id')->on('stages')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('behaviors', function(Blueprint $table) {
			$table->foreign('student_id')->references('id')->on('students')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('behaviors', function(Blueprint $table) {
			$table->foreign('employee_id')->references('id')->on('employees')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('tests_students', function(Blueprint $table) {
			$table->foreign('student_id')->references('id')->on('students')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('accounts', function(Blueprint $table) {
			$table->foreign('moderator_id')->references('id')->on('moderators')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('accounts', function(Blueprint $table) {
			$table->foreign('acccount_cat_id')->references('id')->on('account_cats')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('accounts', function(Blueprint $table) {
			$table->foreign('employee_id')->references('id')->on('employees')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('accounts', function(Blueprint $table) {
			$table->foreign('student_id')->references('id')->on('students')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('students', function(Blueprint $table) {
			$table->dropForeign('students_stage_id_foreign');
		});
		Schema::table('employees', function(Blueprint $table) {
			$table->dropForeign('employees_department_id_foreign');
		});
		Schema::table('departments', function(Blueprint $table) {
			$table->dropForeign('departments_parent_foreign');
		});
		Schema::table('moderator_departments', function(Blueprint $table) {
			$table->dropForeign('moderator_departments_moderator_id_foreign');
		});
		Schema::table('moderator_departments', function(Blueprint $table) {
			$table->dropForeign('moderator_departments_department_id_foreign');
		});
		Schema::table('leaves', function(Blueprint $table) {
			$table->dropForeign('leaves_employee_id_foreign');
		});
		Schema::table('leaves', function(Blueprint $table) {
			$table->dropForeign('leaves_leave_type_foreign');
		});
		Schema::table('leaves', function(Blueprint $table) {
			$table->dropForeign('leaves_department_id_foreign');
		});
		Schema::table('rewards', function(Blueprint $table) {
			$table->dropForeign('rewards_employee_id_foreign');
		});
		Schema::table('rewards', function(Blueprint $table) {
			$table->dropForeign('rewards_moderator_id_foreign');
		});
		Schema::table('borrows', function(Blueprint $table) {
			$table->dropForeign('borrows_employee_id_foreign');
		});
		Schema::table('borrows', function(Blueprint $table) {
			$table->dropForeign('borrows_moderator_id_foreign');
		});
		Schema::table('discounts', function(Blueprint $table) {
			$table->dropForeign('discounts_employee_id_foreign');
		});
		Schema::table('discounts', function(Blueprint $table) {
			$table->dropForeign('discounts_moderator_id_foreign');
		});
		Schema::table('rates', function(Blueprint $table) {
			$table->dropForeign('rates_moderator_id_foreign');
		});
		Schema::table('rates', function(Blueprint $table) {
			$table->dropForeign('rates_employee_id_foreign');
		});
		Schema::table('rates', function(Blueprint $table) {
			$table->dropForeign('rates_student_id_foreign');
		});
		Schema::table('holidays', function(Blueprint $table) {
			$table->dropForeign('holidays_department_id_foreign');
		});
		Schema::table('holidays', function(Blueprint $table) {
			$table->dropForeign('holidays_moderator_id_foreign');
		});
		Schema::table('stages', function(Blueprint $table) {
			$table->dropForeign('stages_parent_foreign');
		});
		Schema::table('behaviors', function(Blueprint $table) {
			$table->dropForeign('behaviors_student_id_foreign');
		});
		Schema::table('behaviors', function(Blueprint $table) {
			$table->dropForeign('behaviors_employee_id_foreign');
		});
		Schema::table('tests_students', function(Blueprint $table) {
			$table->dropForeign('tests_students_student_id_foreign');
		});
		Schema::table('accounts', function(Blueprint $table) {
			$table->dropForeign('accounts_moderator_id_foreign');
		});
		Schema::table('accounts', function(Blueprint $table) {
			$table->dropForeign('accounts_acccount_cat_id_foreign');
		});
		Schema::table('accounts', function(Blueprint $table) {
			$table->dropForeign('accounts_employee_id_foreign');
		});
		Schema::table('accounts', function(Blueprint $table) {
			$table->dropForeign('accounts_student_id_foreign');
		});
	}
}