<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLeavesTable extends Migration {

	public function up()
	{
		Schema::create('leaves', function(Blueprint $table) {
			$table->increments('id');
			$table->datetime('start_from');
			$table->datetime('end_at');
			$table->integer('employee_id')->unsigned();
			$table->integer('leave_type')->unsigned();
			$table->integer('department_id')->unsigned();
			$table->string('image');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('leaves');
	}
}