<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMerchantsTable extends Migration {

	public function up()
	{
		Schema::create('merchants', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name')->nullable();
			$table->string('email')->nullable();
			$table->string('phone')->nullable();
			$table->string('address', 255)->nullable();
			$table->bigInteger('country_id')->nullable();
			$table->bigInteger('city_id')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('merchants');
	}
}