<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateItemSupplierTable extends Migration {

	public function up()
	{
		Schema::create('item_supplier', function(Blueprint $table) {
			$table->increments('id');
			$table->string('import_unique_id');
			$table->integer('item_id')->unsigned()->nullable();
			$table->integer('supplier_id')->unsigned()->nullable();
			$table->integer('quantity');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('item_supplier');
	}
}