<?php

namespace App\Models;

class Eprescription extends Eloquent {

	protected $table = 'e_prescriptions';
	public $timestamps = true;
	protected $fillable = array('booking_id', 'npi', 'dea', 'pharmacy_name', 'pharmacy_address', 'pharmacy_phone', 'pharmacy_fax', 'notes');
	protected $visible = array('booking_id', 'verification_status');

	public function booking_info()
	{
		return $this->hasOne('App\Models\BookingInfo', 'booking_id');
	}

	public function prescription_medicine()
	{
		return $this->hasOne('App\Models\PrescriptionMedication', 'prescription_id');
	}

}