<?php

namespace App\Models;

class MedicalHistory extends Eloquent {

	protected $table = 'medical_histories';
	public $timestamps = true;
	protected $fillable = array('user_id', 'height_in_feet', 'height_in_inch', 'weight', 'smoke', 'alcohol_status', 'doc_last_visit');

	public function users()
	{
		return $this->belongsTo('App\Models\User', 'id');
	}

	public function relativeInfos()
	{
		return $this->hasOne('App\Models\RelativeInfo', 'id');
	}

	public function medications()
	{
		return $this->hasMany('App\Models\Medication', 'history_id');
	}

	public function allergies()
	{
		return $this->hasMany('App\Models\Allergy', 'history_id');
	}

	public function patient_health_problems()
	{
		return $this->hasMany('App\Models\User', 'history_id');
	}

	public function patient_family_problems()
	{
		return $this->hasMany('App\Models\PatientFamilyProblem', 'history_id');
	}

	public function diabetes()
	{
		return $this->hasMany('App\Models\User', 'history_id');
	}

}