<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBookingInfosTable extends Migration {

	public function up()
	{
		Schema::create('booking_infos', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->bigInteger('history_id')->unsigned();
			$table->text('medical_problem')->nullable();
			$table->bigInteger('doctor_id')->unsigned();
			$table->string('image_url', 299)->nullable();
			$table->tinyInteger('status')->default('0');
			$table->integer('slot_id')->unsigned();
			$table->tinyInteger('update_status')->default('0');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('booking_infos');
	}
}