<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateReviewsTable extends Migration {

	public function up()
	{
		Schema::create('reviews', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('booking_id')->unsigned();
			$table->bigInteger('doctor_id')->unsigned();
			$table->bigInteger('patient_id')->unsigned();
			$table->tinyInteger('doctor_satisfaction')->nullable();
			$table->timestamps();
			$table->tinyInteger('patient_satisfaction')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('reviews');
	}
}