<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('restrict')
						->onUpdate('no action');
		});
		Schema::table('medical_histories', function(Blueprint $table) {
			$table->foreign('relative_id')->references('id')->on('relative_infos')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('relative_infos', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('relative_infos', function(Blueprint $table) {
			$table->foreign('relation')->references('id')->on('possible_members_list')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('booking_infos', function(Blueprint $table) {
			$table->foreign('history_id')->references('id')->on('medical_histories')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('booking_infos', function(Blueprint $table) {
			$table->foreign('doctor_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('booking_infos', function(Blueprint $table) {
			$table->foreign('slot_id')->references('id')->on('doctors_slots')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('doctors_slots', function(Blueprint $table) {
			$table->foreign('sloted_date_id')->references('id')->on('sloted_dates')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('doctors_slots', function(Blueprint $table) {
			$table->foreign('doctor_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('prescriptions', function(Blueprint $table) {
			$table->foreign('booking_id')->references('id')->on('booking_infos')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('payments', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('payments', function(Blueprint $table) {
			$table->foreign('booking_id')->references('id')->on('booking_infos')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('reviews', function(Blueprint $table) {
			$table->foreign('booking_id')->references('id')->on('booking_infos')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('reviews', function(Blueprint $table) {
			$table->foreign('doctor_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('reviews', function(Blueprint $table) {
			$table->foreign('patient_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('medications', function(Blueprint $table) {
			$table->foreign('history_id')->references('id')->on('medical_histories')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('allergies', function(Blueprint $table) {
			$table->foreign('history_id')->references('id')->on('medical_histories')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('patient_family_prolems', function(Blueprint $table) {
			$table->foreign('history_id')->references('id')->on('medical_histories')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('patient_family_prolems', function(Blueprint $table) {
			$table->foreign('family_problem_id')->references('id')->on('family_problems')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('patient_health_problems', function(Blueprint $table) {
			$table->foreign('history_id')->references('id')->on('medical_histories')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('patient_health_problems', function(Blueprint $table) {
			$table->foreign('health_problem_id')->references('id')->on('health_prolems')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('doctor_infos', function(Blueprint $table) {
			$table->foreign('doctor_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('no action');
		});
		Schema::table('diabetes', function(Blueprint $table) {
			$table->foreign('history_id')->references('id')->on('medical_histories')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('diabetes', function(Blueprint $table) {
			$table->foreign('who_has')->references('id')->on('possible_members_list')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('sloted_dates', function(Blueprint $table) {
			$table->foreign('doctor_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('e_prescriptions', function(Blueprint $table) {
			$table->foreign('booking_id')->references('id')->on('booking_infos')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('prescription_medication', function(Blueprint $table) {
			$table->foreign('prescription_id')->references('id')->on('e_prescriptions')
						->onDelete('no action')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_role_id_foreign');
		});
		Schema::table('medical_histories', function(Blueprint $table) {
			$table->dropForeign('medical_histories_relative_id_foreign');
		});
		Schema::table('relative_infos', function(Blueprint $table) {
			$table->dropForeign('relative_infos_user_id_foreign');
		});
		Schema::table('relative_infos', function(Blueprint $table) {
			$table->dropForeign('relative_infos_relation_foreign');
		});
		Schema::table('booking_infos', function(Blueprint $table) {
			$table->dropForeign('booking_infos_history_id_foreign');
		});
		Schema::table('booking_infos', function(Blueprint $table) {
			$table->dropForeign('booking_infos_doctor_id_foreign');
		});
		Schema::table('booking_infos', function(Blueprint $table) {
			$table->dropForeign('booking_infos_slot_id_foreign');
		});
		Schema::table('doctors_slots', function(Blueprint $table) {
			$table->dropForeign('doctors_slots_sloted_date_id_foreign');
		});
		Schema::table('doctors_slots', function(Blueprint $table) {
			$table->dropForeign('doctors_slots_doctor_id_foreign');
		});
		Schema::table('prescriptions', function(Blueprint $table) {
			$table->dropForeign('prescriptions_booking_id_foreign');
		});
		Schema::table('payments', function(Blueprint $table) {
			$table->dropForeign('payments_user_id_foreign');
		});
		Schema::table('payments', function(Blueprint $table) {
			$table->dropForeign('payments_booking_id_foreign');
		});
		Schema::table('reviews', function(Blueprint $table) {
			$table->dropForeign('reviews_booking_id_foreign');
		});
		Schema::table('reviews', function(Blueprint $table) {
			$table->dropForeign('reviews_doctor_id_foreign');
		});
		Schema::table('reviews', function(Blueprint $table) {
			$table->dropForeign('reviews_patient_id_foreign');
		});
		Schema::table('medications', function(Blueprint $table) {
			$table->dropForeign('medications_history_id_foreign');
		});
		Schema::table('allergies', function(Blueprint $table) {
			$table->dropForeign('allergies_history_id_foreign');
		});
		Schema::table('patient_family_prolems', function(Blueprint $table) {
			$table->dropForeign('patient_family_prolems_history_id_foreign');
		});
		Schema::table('patient_family_prolems', function(Blueprint $table) {
			$table->dropForeign('patient_family_prolems_family_problem_id_foreign');
		});
		Schema::table('patient_health_problems', function(Blueprint $table) {
			$table->dropForeign('patient_health_problems_history_id_foreign');
		});
		Schema::table('patient_health_problems', function(Blueprint $table) {
			$table->dropForeign('patient_health_problems_health_problem_id_foreign');
		});
		Schema::table('doctor_infos', function(Blueprint $table) {
			$table->dropForeign('doctor_infos_doctor_id_foreign');
		});
		Schema::table('diabetes', function(Blueprint $table) {
			$table->dropForeign('diabetes_history_id_foreign');
		});
		Schema::table('diabetes', function(Blueprint $table) {
			$table->dropForeign('diabetes_who_has_foreign');
		});
		Schema::table('sloted_dates', function(Blueprint $table) {
			$table->dropForeign('sloted_dates_doctor_id_foreign');
		});
		Schema::table('e_prescriptions', function(Blueprint $table) {
			$table->dropForeign('e_prescriptions_booking_id_foreign');
		});
		Schema::table('prescription_medication', function(Blueprint $table) {
			$table->dropForeign('prescription_medication_prescription_id_foreign');
		});
	}
}