<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class BankingAccount extends Model 
{

    protected $table = 'banking_account';
    public $timestamps = true;

    public function expenses()
    {
        return $this->hasMany('Operation');
    }

    public function balances()
    {
        return $this->hasMany('Balance');
    }

    public function invitations()
    {
        return $this->hasMany('Invitation');
    }

    public function users()
    {
        return $this->hasMany('UserBankingAccount');
    }

}