<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserTable extends Migration {

	public function up()
	{
		Schema::create('user', function(Blueprint $table) {
			$table->increments('id');
			$table->string('first_name')->nullable();
			$table->string('last_name')->nullable();
			$table->string('email');
			$table->string('password');
			$table->string('token_reset_password')->nullable();
			$table->datetime('token_reset_exp_date')->nullable();
			$table->tinyInteger('login_attempts')->unsigned()->default('0');
			$table->datetime('login_attempts_last_date')->nullable();
			$table->tinyInteger('status')->unsigned()->default('1');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('user');
	}
}