<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('scores', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('score_details', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('score_details', function(Blueprint $table) {
			$table->foreign('score_list_id')->references('uuid')->on('score_lists')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('scores', function(Blueprint $table) {
			$table->dropForeign('scores_user_id_foreign');
		});
		Schema::table('score_details', function(Blueprint $table) {
			$table->dropForeign('score_details_user_id_foreign');
		});
		Schema::table('score_details', function(Blueprint $table) {
			$table->dropForeign('score_details_score_list_id_foreign');
		});
	}
}