<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTasksTable extends Migration {

	public function up()
	{
		Schema::create('tasks', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('client_id');
			$table->integer('project_id');
			$table->string('task_name');
			$table->string('task_priority');
			$table->string('task_status');
			$table->date('task_start_date');
			$table->date('task_end_date');
			$table->text('task_information');
		});
	}

	public function down()
	{
		Schema::drop('tasks');
	}
}