<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateIntegrationProvidersTable extends Migration {

	public function up()
	{
		Schema::create('integration_providers', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name')->unique();
			$table->boolean('actived_at')->default(false);
			$table->json('auth_form')->nullable();
			$table->enum('mode', array('production', 'patient_and_treatment'));
		});
	}

	public function down()
	{
		Schema::drop('integration_providers');
	}
}