<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Projects extends Eloquent {

	protected $table = 'projects';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'slack_id', 'red_pill_link', 'type', 'status', 'pm_id', 'dm_id', 'created_by', 'updated_by');

	public function getPM()
	{
		return $this->hasOne('User', 'pm_id');
	}

	public function getDM()
	{
		return $this->hasOne('User', 'dm_id');
	}

}