<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCompaniesTable extends Migration {

	public function up()
	{
		Schema::create('companies', function(Blueprint $table) {
			$table->increments('id', true);
			$table->string('site', 255);
			$table->string('name', 255);
			$table->integer('category_id')->unsigned();
			$table->integer('country_id')->unsigned();
			$table->integer('city_id')->unsigned();
			$table->integer('attach_id')->unsigned();
			$table->string('address', 255);
			$table->enum('status', array('Pending', 'Rejected', 'Approved'));
			$table->timestamps();
			$table->softDeletes();
			$table->string('phone', 255);
		});
	}

	public function down()
	{
		Schema::drop('companies');
	}
}